<?php
// register.php (web form)
$err = isset($_GET['error']) ? $_GET['error'] : '';
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8" />
  <title>Lakwatcha - Register</title>
  <link rel="stylesheet" href="styles.css">
</head>
<body>

  <div class="auth-wrapper">
    <div class="auth-card">

      <!-- Right side with GIF -->
      <div class="auth-right">
        <img class="hero" src="assets/Logo3.png" alt="Lakwatcha illustration">
      </div>

      <!-- Left side form -->
      <div class="auth-left">
        <div class="brand">
          <span class="logo"></span>
          <span>Lakwatcha</span>
        </div>

        <h1>Create Account</h1>
        <p class="helper">Fill in the details below to get started.</p>

        <?php if ($err): ?>
          <div class="notice err"><?php echo htmlspecialchars($err, ENT_QUOTES); ?></div>
        <?php endif; ?>

        <form class="form" method="post" action="config.php?action=register" enctype="multipart/form-data">
          <input type="hidden" name="redirect" value="1" />

          <div style="display:grid; grid-template-columns:1fr 1fr; gap:12px;">
            <div>
              <label class="label">First Name</label>
              <input class="input" type="text" name="first_name" required />
            </div>
            <div>
              <label class="label">Last Name</label>
              <input class="input" type="text" name="last_name" required />
            </div>
          </div>

          <div>
            <label class="label">Username</label>
            <input class="input" type="text" name="username" required />
          </div>

          <div>
            <label class="label">Email</label>
            <input class="input" type="email" name="email" required />
          </div>

          <div style="display:grid; grid-template-columns:1fr 1fr; gap:12px;">
            <div>
              <label class="label">Age</label>
              <input class="input" type="number" name="age" min="1" required />
            </div>
            <div>
              <label class="label">Gender</label>
              <div style="display:flex; gap:18px; align-items:center; padding-top:10px;">
                <label><input type="radio" name="gender" value="Male" required /> Male</label>
                <label><input type="radio" name="gender" value="Female" required /> Female</label>
              </div>
            </div>
          </div>

          <div>
            <label class="label">Password</label>
            <input class="input" type="password" name="password" required />
          </div>

          <div>
            <label class="label">Register For</label>
            <div style="display:flex; gap:18px; align-items:center; padding-top:10px;">
              <label><input type="radio" name="register_for" value="User" checked /> User</label>
              <label><input type="radio" name="register_for" value="Admin" /> Admin</label>
            </div>
          </div>

          <div>
            <label class="label">Profile Photo</label>
            <input class="input" type="file" name="profile_photo" accept="image/*" />
          </div>

          <button class="btn" type="submit">Submit</button>
        </form>

        <p class="meta">Already have an account? <a class="link" href="login.php">Login</a></p>
      </div>

    </div>
  </div>

</body>
</html>
