<?php
// login.php (web form)
session_start();
$registered = isset($_GET['registered']);
$error = isset($_GET['error']) ? $_GET['error'] : '';
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8" />
  <title>Lakwatcha - Login</title>
  <link rel="stylesheet" href="styles.css">
</head>
<body>

  <div class="auth-wrapper">
    <div class="auth-card">

      <!-- Right side with GIF (shows first on mobile) -->
      <div class="auth-right">
        <img class="hero" src="assets/Logo3.png" alt="Lakwatcha illustration">
      </div>

      <!-- Left side form -->
      <div class="auth-left">
        <div class="brand">
          <span class="logo"></span>
          <span>Lakwatcha</span>
        </div>

        <h1>Welcome Back</h1>
        <p class="helper">Please enter your details</p>

        <?php if ($registered): ?>
          <div class="notice ok">Registration successful. Please log in.</div>
        <?php endif; ?>

        <?php if ($error): ?>
          <div class="notice err"><?php echo htmlspecialchars($error, ENT_QUOTES); ?></div>
        <?php endif; ?>

        <form class="form" method="post" action="config.php?action=login">
          <input type="hidden" name="redirect" value="1" />
          <div>
            <label class="label">Email</label>
            <input class="input" type="email" name="email" placeholder="you@example.com" required />
          </div>
          <div>
            <label class="label">Password</label>
            <input class="input" type="password" name="password" placeholder="Your password" required />
          </div>
          <button class="btn" type="submit">Sign In</button>
        </form>

        <p class="meta">Don’t have an account? <a class="link" href="register.php">Sign up</a></p>
      </div>

    </div>
  </div>

</body>
</html>
