<?php
// index.php - dashboard
session_start();
if (!isset($_SESSION['email'])) {
  header('Location: login.php');
  exit;
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8" />
  <title>Lakwatcha - Dashboard</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <!-- Your theme -->
  <link rel="stylesheet" href="styles.css" />
  <!-- Chart.js -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1"></script>
</head>
<body>

  <div class="dash-wrapper">
    <header class="dash-topbar">
      <div class="dash-id">
        <div class="brand">
          <span class="logo"></span>
          Lakwatcha Admin
        </div>
        <div class="dash-welcome">
          Welcome,
          <strong><?php echo htmlspecialchars($_SESSION['name'] ?? $_SESSION['email'], ENT_QUOTES); ?></strong>
          <span class="role-pill"><?php echo htmlspecialchars($_SESSION['role'] ?? 'user', ENT_QUOTES); ?></span>
        </div>
      </div>
      <nav class="dash-actions">
        <a class="btn btn-ghost" href="logout.php">Logout</a>
      </nav>
    </header>

    <!-- STAT + DRIVE -->
    <section class="stat-grid">
      <article class="card">
        <div class="card-head">
          <h3>Users vs Admins</h3>
        </div>
        <div class="card-body">
          <div class="chart-wrap">
            <canvas id="mixChart"></canvas>
          </div>
        </div>
      </article>

      <article class="card">
        <div class="card-head">
          <h3>Drive Videos</h3>
          <button class="btn btn-sm" onclick="loadDrive()">Reload</button>
        </div>
        <div class="card-body">
          <ul id="driveList" class="drive-list"></ul>
        </div>
      </article>
    </section>

    <!-- PEOPLE -->
    <section class="card">
      <div class="card-head">
        <h3>People</h3>
        <button class="btn btn-sm" onclick="loadPeople()">Reload</button>
      </div>

      <div class="people-grid">
        <div class="people-col">
          <h4 class="table-title">Users</h4>
          <div class="table-wrap">
            <table id="usersTable" class="nice-table">
              <thead>
                <tr><th>Name</th><th>Email</th><th>Gender</th><th>Age</th></tr>
              </thead>
              <tbody></tbody>
            </table>
          </div>
        </div>

        <div class="people-col">
          <h4 class="table-title">Admins</h4>
          <div class="table-wrap">
            <table id="adminsTable" class="nice-table">
              <thead>
                <tr><th>Name</th><th>Email</th><th>Gender</th><th>Age</th></tr>
              </thead>
              <tbody></tbody>
            </table>
          </div>
        </div>
      </div>
    </section>
  </div>

<script>
async function fetchJSON(url, opts={}) {
  const r = await fetch(url, opts);
  return await r.json();
}

// ------ Chart
let mixChartInstance = null;
async function loadStats() {
  const data = await fetchJSON('config.php?action=stats');
  if (!data.ok) return;

  // Build gradient fills that match your palette
  const ctx = document.getElementById('mixChart').getContext('2d');
  const teal = ctx.createLinearGradient(0, 0, 0, 300);
  teal.addColorStop(0, 'rgba(18,124,118,0.9)');  // var(--ring) base hue
  teal.addColorStop(1, 'rgba(11,79,76,0.75)');   // --bg-darker

  const orange = ctx.createLinearGradient(0, 0, 0, 300);
  orange.addColorStop(0, 'rgba(245,158,11,0.95)'); // --accent
  orange.addColorStop(1, 'rgba(245,158,11,0.65)');

  if (mixChartInstance) { mixChartInstance.destroy(); }
  mixChartInstance = new Chart(ctx, {
    type: 'bar',
    data: {
      labels: ['Users','Admins'],
      datasets: [{
        label: 'Count',
        data: [data.users, data.admins],
        backgroundColor: [teal, orange],
        borderRadius: 10,
        borderSkipped: false,
        borderColor: 'rgba(255,255,255,.6)',
        borderWidth: 1
      }]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,           // allow the canvas to fill the wrap
      plugins: {
        legend: { display: false },
        tooltip: {
          backgroundColor: 'rgba(14,27,27,.92)',
          titleColor: '#fff',
          bodyColor: '#fff',
          padding: 10,
          cornerRadius: 8,
          displayColors: false,
          callbacks: {
            label: (ctx) => `${ctx.label}: ${ctx.formattedValue}`
          }
        }
      },
      scales: {
        x: {
          grid: { display: false },
          ticks: { color: '#6B8C8B', font: { weight: 600 } }
        },
        y: {
          beginAtZero: true,
          grid: { color: 'rgba(11,79,76,.08)' },
          ticks: { color: '#6B8C8B', precision: 0, stepSize: 1 }
        }
      },
      animation: { duration: 600, easing: 'easeOutQuart' }
    }
  });
}
loadStats();

// ------ People
async function loadPeople() {
  const data = await fetchJSON('config.php?action=list');
  if (!data.ok) return;
  const ut = document.querySelector('#usersTable tbody');
  const at = document.querySelector('#adminsTable tbody');
  ut.innerHTML = ''; at.innerHTML = '';

  (data.users || []).forEach(p => {
    ut.innerHTML += `<tr>
      <td>${p.first_name} ${p.last_name}</td>
      <td><a href="mailto:${p.email}" class="table-link">${p.email}</a></td>
      <td>${p.gender}</td>
      <td>${p.age}</td>
    </tr>`;
  });

  (data.admins || []).forEach(p => {
    at.innerHTML += `<tr>
      <td>${p.first_name} ${p.last_name}</td>
      <td><a href="mailto:${p.email}" class="table-link">${p.email}</a></td>
      <td>${p.gender}</td>
      <td>${p.age}</td>
    </tr>`;
  });
}
loadPeople();

// ------ Drive
async function loadDrive() {
  const data = await fetchJSON('config.php?action=drive_list_videos');
  const ul = document.getElementById('driveList');
  ul.innerHTML = '';
  if (!data.ok) {
    ul.innerHTML = `<li class="empty">Failed: ${data.error||'Error'}</li>`;
    return;
  }
  const files = (data.data && data.data.files) ? data.data.files : [];
  if (files.length === 0) {
    ul.innerHTML = `<li class="empty">No videos found</li>`;
    return;
  }
  files.forEach(f => {
    const link = f.webViewLink || f.webContentLink || '#';
    ul.innerHTML += `<li><a class="drive-link" href="${link}" target="_blank" rel="noopener">${f.name}</a></li>`;
  });
}
loadDrive();
</script>

</body>
</html>
